/*! @license MIT ©2013 Ruben Verborgh */
var N3Writer = require('n3').Writer;

/* Prefixes */
var rdfs = 'http://www.w3.org/2000/01/rdf-schema#';
var foaf = 'http://xmlns.com/foaf/0.1/';
var prefixes = {
  rdfs: rdfs,
  foaf: foaf,
};

/* A generator of Turtle representations. */
function TurtleRepresenter() { }

// Represents the specified resource
TurtleRepresenter.prototype.represent = function (resource) {
  // Set up writer
  var writer = new N3Writer(prefixes), result,
      documentUrl = resource.url,
      baseUrl = documentUrl + '#',
      resourceUrl = baseUrl + 'concept',
      label = '"' + (resource.title || resource.name) + '"@en';
  writer.addPrefix('', baseUrl);

  // Add the triples
  writer.addTriple(documentUrl, foaf + 'primaryTopic', resourceUrl);
  writer.addTriple(resourceUrl, rdfs + 'label', label);

  // Send back the result
  return writer.end(function (error, turtle) { result = turtle; }), result;
};

module.exports = TurtleRepresenter;
